#include "CameraCBuffer.hlsli"
#include "SamplerStates.hlsli"

#include "Common.hlsli"

Texture2D RenderTargetTex : register(t0);
Texture2D<float2> DepthAndCoCRadiusTex : register(t1);

Texture2D<float> PositiveSATex : register(t2);
Texture2D<float> ZeroSATex : register(t3);
Texture2D<float> NegativeSATex : register(t4);

Texture2D<float> BokehTex : register(t5);

struct PSInput
{
	float4 PositionViewportS : SV_Position;
	float4 Color : Color;
	float2 TexCoords : TexCoord0;
	float SphericalAmount : SA;
};

struct PSOutput
{
	float4 target0 : SV_Target0; // Foreground blur rendertarget
	float4 target1 : SV_Target1; // Background blur rendertarget
};

PSOutput main(PSInput input)
{
	PSOutput output = (PSOutput)0;

	float4 color = input.Color;

	// Apply the bokeh mask
	color.a *= BokehTex.Sample(LinearSampler, input.TexCoords);

	// Z is set to 0 to indicate foreground blur, and 1 to indicate background blur
	bool isForegroundBlur = input.PositionViewportS.z < 0.5;

	float positiveSA = PositiveSATex.Sample(LinearSampler, input.TexCoords);
	float zeroSA = ZeroSATex.Sample(LinearSampler, input.TexCoords);
	float negativeSA = NegativeSATex.Sample(LinearSampler, input.TexCoords);
	
	// Positive SA values indicate smooth blur, and negative SA values indicate harsh blur.
	if(input.SphericalAmount > 0) {
		color.a *= lerp(zeroSA, positiveSA, input.SphericalAmount);
	} else {
		color.a *= lerp(zeroSA, negativeSA, -input.SphericalAmount);
	}

	if(isForegroundBlur) {
		// Foreground blur
		output.target0 = color;
	} else {
		// Background blur
		output.target1 = color;
	}
	
	return output;
}